﻿
namespace AlbumsCatalog.Web
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.ComponentModel.DataAnnotations;
    using System.Data;
    using System.Linq;
    using System.ServiceModel.DomainServices.EntityFramework;
    using System.ServiceModel.DomainServices.Hosting;
    using System.ServiceModel.DomainServices.Server;


    // Implements application logic using the AlbumsEntities context.
    // TODO: Add your application logic to these methods or in additional methods.
    // TODO: Wire up authentication (Windows/ASP.NET Forms) and uncomment the following to disable anonymous access
    // Also consider adding roles to restrict access as appropriate.
    // [RequiresAuthentication]
    [EnableClientAccess()]
    public class AlbumsDomainService : LinqToEntitiesDomainService<AlbumsEntities>
    {

        // TODO:
        // Consider constraining the results of your query method.  If you need additional input you can
        // add parameters to this method or create additional query methods with different names.
        // To support paging you will need to add ordering to the 'Albums' query.
        public IQueryable<Album> GetAlbums()
        {
            return this.ObjectContext.Albums;
        }

        // TODO:
        // Consider constraining the results of your query method.  If you need additional input you can
        // add parameters to this method or create additional query methods with different names.
        // To support paging you will need to add ordering to the 'Artists' query.
        public IQueryable<Artist> GetArtists()
        {
            return this.ObjectContext.Artists;
        }

        public IQueryable<Artist> GetArtistsWithAlbums()
        {
            return this.ObjectContext.Artists.Include("Albums");
        }

        // TODO:
        // Consider constraining the results of your query method.  If you need additional input you can
        // add parameters to this method or create additional query methods with different names.
        // To support paging you will need to add ordering to the 'Tracks' query.
        public IQueryable<Track> GetTracks()
        {
            return this.ObjectContext.Tracks;
        }

        public void InsertTrack(Track track)
        {
            if ((track.EntityState != EntityState.Detached))
            {
                this.ObjectContext.ObjectStateManager.ChangeObjectState(track, EntityState.Added);
            }
            else
            {
                this.ObjectContext.Tracks.AddObject(track);
            }
        }

        public void UpdateTrack(Track currentTrack)
        {
            this.ObjectContext.Tracks.AttachAsModified(currentTrack, this.ChangeSet.GetOriginal(currentTrack));
        }

        public void DeleteTrack(Track track)
        {
            if ((track.EntityState == EntityState.Detached))
            {
                this.ObjectContext.Tracks.Attach(track);
            }
            this.ObjectContext.Tracks.DeleteObject(track);
        }
    }
}


